/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	RemoveConstraints.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CConstraints.h"
#include "CApplication.h"


HRESULT RemoveConstraints(IObjectOrSet *objSet, long nature)
{

	//	Removes all the constraints associated with the set of given lines
	
	START_METHOD("RemoveConstraints")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ISet *pInside = NULL;
	ISet *pOutside = NULL;

	ISet *pNeither = NULL;

	status = activeWorkplane->SeparateConstraints(objSet, &pInside, &pOutside, &pNeither);
	CHECK_RETURN_STATUS(status)

	ISet *inside = NULL;
	ISet *pInsideExplicit = NULL;

	if(pInside!=NULL) {

		status = RemoveImplicit(pInside, &pInsideExplicit);
		CHECK_RETURN_STATUS(status)
	}

	ISet *neither = NULL;
	ISet *pNeitherExplicit = NULL;

	if(pNeither!=NULL) {
		
		status = RemoveImplicit(pNeither, &pNeitherExplicit);
		CHECK_RETURN_STATUS(status)
	}

	ISet *pConstraintSet = NULL;
	ISet *pTotalSet = NULL;
	ISet *totalSet = NULL;

	switch(nature) {
	case 0:
		if(pNeither!=NULL)
			pConstraintSet = pNeither;
		break;

	case 1:
		if(pInside!=NULL)
			pConstraintSet = pInside;
		break;

	case 2:
		status = (GetCLASS(ObjectSet))->CreateAObjectSet(&pTotalSet);
		CHECK_RETURN_STATUS(status)

		status = AddSet(pTotalSet, pInside);
		CHECK_RETURN_STATUS(status)

		status = AddSet(pTotalSet, pNeither);
		CHECK_RETURN_STATUS(status)

		pConstraintSet = pTotalSet;
	}

	long noOfConstraints = 0;

	status = pConstraintSet->GetCount(&noOfConstraints);
	CHECK_RETURN_STATUS(status)

	for( int i=0; i<noOfConstraints; i++ ) {
		IDispatch *pDisp = NULL;

		status = pConstraintSet->GetObjectAt(i, &pDisp);
		CHECK_RETURN_STATUS(status)
	}

	status = pConstraintSet->RemoveAll();
	CHECK_RETURN_STATUS(status)

	END_METHOD("RemoveConstraints")
}

HRESULT RemoveImplicit(ISet *objectSet1, ISet **objectSet2)
{
	START_METHOD("RemoveImplicit")

	HRESULT status = CONV_SUCCESS;

	// create an object set
	ISet *pResultSet = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&pResultSet);
	CHECK_RETURN_STATUS(status)

	long noOfConstraints = 0;

	status = objectSet1->GetCount(&noOfConstraints);
	CHECK_RETURN_STATUS(status)

	for( int i=0; i<noOfConstraints; i++ ) {
		IDispatch *pDisp = NULL;

		status = objectSet1->GetObjectAt(i, &pDisp);
		CHECK_RETURN_STATUS(status)

		IConstraint *aConstraint = CAST(IConstraint, pDisp);

		VARIANT_BOOL bVal;
		status = aConstraint->IsImplicit(&bVal);
		CHECK_RETURN_STATUS(status)

		if(!bVal) {
			status = pResultSet->AddMember(aConstraint);
			CHECK_RETURN_STATUS(status)
		}
	}

	*objectSet2 = pResultSet;
	
	END_METHOD("RemoveImplicit")
}
